-- Modern

-- Use this function to perform your initial setup
gameWorld = scene.default2d()
function setup()
    
    viewer.mode = FULLSCREEN
    
    scene.main = gameWorld
    gameWorld.time.autoUpdate = false
  --  gameWorld.canvas = ui.canvas()
    
    gameWorld.camera:get(camera).orthoSize = 24
    img = image.read(asset.builtin.Planet_Cute.Character_Boy)
    gameWorld.sky = img

    gameWorld.pixelsPerUnit = 64
    --gameWorld.physics2d.debugDraw =true
    
    gameManager = gameWorld:entity("Manager")
    gameManager:add(GameManager)
    gameManager:add(UIManager)
    gameManager:add(AudioManager)
    
    bird = gameWorld:entity("Bird")
    bird:add(physics2d.body, DYNAMIC)
    bird:add(Bird, 1.2)
    bird:add(Jump, 1900)

    floor = gameWorld:entity("Floor")
    floor:add(physics2d.body, STATIC)
    floor:add(Floor, 4, 1.2)
    
    pipeManager = gameWorld:entity("pipeManager")
    pipeManager:add(PipeManager, 3, 12, 7, 6, 5.5, 0.7)
    
    backGround = gameWorld:entity("background")
    backGround:add(Background, vec2(16,16), color(155, 196, 215), color(143, 185, 217))
    
    
    
end

function sizeChanged(w, h)
    WIDTH = w
    HEIGHT = h
    --1366.0
    if w < h then
        scalefactor = (w + 0.) * h
        
        gameWorld.canvas.scale = (1366. /w) /1.42
        gameWorld.camera:get(camera).orthoSize = 24 +  5 *(1366. / w)
    else
        scalefactor = (h + 0.) * w
        
        gameWorld.canvas.scale = 1024. /h
        gameWorld.camera:get(camera).orthoSize = 24 
    end
end
    

-- This function gets called once every frame
function draw()
    background(223, 169, 169)
    gameWorld:update(time.delta)
    gameWorld:draw()
   -- gameWorld:draw()
end

